/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.fabric.networking_api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.impl.networking.PayloadTypeRegistryImpl;
import net.fabricmc.fabric.mixin.networking.accessor.NetworkRegistryAccessor;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.ChannelAttributes;
import net.neoforged.neoforge.network.registration.NetworkPayloadSetup;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class NeoNetworkRegistrar {
    public static final StreamCodec<?, ?> DUMMY_CODEC = StreamCodec.of((a, b) -> {
        throw new UnsupportedOperationException();
    }, a -> {
        throw new UnsupportedOperationException();
    });
    private final ConnectionProtocol protocol;
    private final Map<ResourceLocation, NeoPayloadHandler<?>> registeredPayloads = new ConcurrentHashMap();

    public NeoNetworkRegistrar(ConnectionProtocol protocol) {
        this.protocol = protocol;
    }

    public static boolean hasCodecFor(ConnectionProtocol protocol, PacketFlow flow, ResourceLocation id) {
        PayloadTypeRegistryImpl<? extends FriendlyByteBuf> registry = NeoNetworkRegistrar.getPayloadRegistry(protocol, flow);
        return registry.get(id) != null;
    }

    public static PayloadTypeRegistryImpl<? extends FriendlyByteBuf> getPayloadRegistry(ConnectionProtocol protocol, PacketFlow flow) {
        if (protocol == ConnectionProtocol.PLAY) {
            return flow == PacketFlow.SERVERBOUND ? PayloadTypeRegistryImpl.PLAY_C2S : PayloadTypeRegistryImpl.PLAY_S2C;
        }
        if (protocol == ConnectionProtocol.CONFIGURATION) {
            return flow == PacketFlow.SERVERBOUND ? PayloadTypeRegistryImpl.CONFIGURATION_C2S : PayloadTypeRegistryImpl.CONFIGURATION_S2C;
        }
        throw new UnsupportedOperationException();
    }

    public <PAYLOAD extends CustomPacketPayload, CONTEXT, HANDLER> boolean registerGlobalReceiver(CustomPacketPayload.Type<PAYLOAD> type, PacketFlow packetFlow, HANDLER handler, Function<IPayloadContext, CONTEXT> ctxFactory, TriConsumer<HANDLER, PAYLOAD, CONTEXT> consumer) {
        NeoPayloadHandler<PAYLOAD> neoHandler = this.getOrRegisterNativeHandler(type);
        return neoHandler.registerGlobalHandler(packetFlow, handler, ctxFactory, consumer);
    }

    public <HANDLER> HANDLER unregisterGlobalReceiver(ResourceLocation id, PacketFlow flow) {
        NeoPayloadHandler<?> neoHandler = this.registeredPayloads.get(id);
        return neoHandler != null ? (HANDLER)neoHandler.unregisterGlobalHandler(flow) : null;
    }

    public Set<ResourceLocation> getGlobalReceivers(PacketFlow flow) {
        return this.registeredPayloads.entrySet().stream().filter(e -> ((NeoPayloadHandler)e.getValue()).hasGlobalHandler(flow)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public <PAYLOAD extends CustomPacketPayload, CONTEXT, HANDLER> boolean registerLocalReceiver(CustomPacketPayload.Type<PAYLOAD> type, ICommonPacketListener listener, HANDLER handler, Function<IPayloadContext, CONTEXT> ctxFactory, TriConsumer<HANDLER, PAYLOAD, CONTEXT> consumer) {
        NeoPayloadHandler<PAYLOAD> neoHandler = this.getOrRegisterNativeHandler(type);
        return neoHandler.registerLocalReceiver(listener, handler, ctxFactory, consumer);
    }

    public <HANDLER> HANDLER unregisterLocalReceiver(ResourceLocation id, ICommonPacketListener listener) {
        NeoPayloadHandler<?> neoHandler = this.registeredPayloads.get(id);
        return neoHandler != null ? (HANDLER)neoHandler.unregisterLocalHandler(listener) : null;
    }

    public Set<ResourceLocation> getLocalReceivers(ICommonPacketListener listener) {
        return this.registeredPayloads.entrySet().stream().filter(e -> ((NeoPayloadHandler)e.getValue()).hasLocalHandler(listener)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<ResourceLocation> getLocalSendable(ICommonPacketListener listener) {
        NetworkPayloadSetup payloadSetup = ChannelAttributes.getPayloadSetup((Connection)listener.getConnection());
        if (payloadSetup == null) {
            return Set.of();
        }
        return ((Map)payloadSetup.channels().get(this.protocol)).keySet();
    }

    private <PAYLOAD extends CustomPacketPayload> NeoPayloadHandler<PAYLOAD> getOrRegisterNativeHandler(CustomPacketPayload.Type<PAYLOAD> type) {
        return this.registeredPayloads.computeIfAbsent(type.id(), k -> {
            NeoPayloadHandler handler = new NeoPayloadHandler();
            boolean setup = NetworkRegistryAccessor.getSetup();
            NetworkRegistryAccessor.setSetup(false);
            NetworkRegistry.register((CustomPacketPayload.Type)type, DUMMY_CODEC, handler, handler, List.of(this.protocol), Optional.empty(), (String)"1.0", (boolean)true);
            NetworkRegistryAccessor.setSetup(setup);
            return handler;
        });
    }

    public static class NeoPayloadHandler<PAYLOAD extends CustomPacketPayload>
    implements IPayloadHandler<PAYLOAD> {
        private final Map<PacketFlow, NeoSubHandler<PAYLOAD, ?, ?>> globalReceivers = new HashMap();
        private final Map<ICommonPacketListener, NeoSubHandler<PAYLOAD, ?, ?>> localReceivers = new HashMap();

        public void handle(PAYLOAD arg, IPayloadContext context) {
            NeoSubHandler localHandler;
            NeoSubHandler globalHandler = this.globalReceivers.get(context.flow());
            if (globalHandler != null) {
                context.enqueueWork(() -> globalHandler.consumer().accept(globalHandler.handler(), arg, globalHandler.ctxFactory().apply(context)));
            }
            if ((localHandler = this.localReceivers.get(context.listener())) != null) {
                context.enqueueWork(() -> localHandler.consumer().accept(localHandler.handler(), arg, localHandler.ctxFactory().apply(context)));
            }
        }

        public boolean hasGlobalHandler(PacketFlow flow) {
            return this.globalReceivers.containsKey(flow);
        }

        public <CONTEXT, HANDLER> boolean registerGlobalHandler(PacketFlow flow, HANDLER original, Function<IPayloadContext, CONTEXT> ctxFactory, TriConsumer<HANDLER, PAYLOAD, CONTEXT> consumer) {
            if (!this.hasGlobalHandler(flow)) {
                this.globalReceivers.put(flow, new NeoSubHandler<PAYLOAD, CONTEXT, HANDLER>(original, ctxFactory, consumer));
                return true;
            }
            return false;
        }

        public boolean hasLocalHandler(ICommonPacketListener listener) {
            return this.localReceivers.containsKey(listener);
        }

        public <CONTEXT, HANDLER> boolean registerLocalReceiver(ICommonPacketListener listener, HANDLER original, Function<IPayloadContext, CONTEXT> ctxFactory, TriConsumer<HANDLER, PAYLOAD, CONTEXT> consumer) {
            if (!this.hasLocalHandler(listener)) {
                this.localReceivers.put(listener, new NeoSubHandler<PAYLOAD, CONTEXT, HANDLER>(original, ctxFactory, consumer));
                return true;
            }
            return false;
        }

        @Nullable
        public <HANDLER> HANDLER unregisterGlobalHandler(PacketFlow flow) {
            NeoSubHandler<PAYLOAD, ?, ?> subHandler = this.globalReceivers.remove(flow);
            return subHandler != null ? (HANDLER)subHandler.handler() : null;
        }

        @Nullable
        public <HANDLER> HANDLER unregisterLocalHandler(ICommonPacketListener listener) {
            NeoSubHandler<PAYLOAD, ?, ?> subHandler = this.localReceivers.remove(listener);
            return subHandler != null ? (HANDLER)subHandler.handler() : null;
        }
    }

    record NeoSubHandler<PAYLOAD extends CustomPacketPayload, CONTEXT, HANDLER>(HANDLER handler, Function<IPayloadContext, CONTEXT> ctxFactory, TriConsumer<HANDLER, PAYLOAD, CONTEXT> consumer) {
    }
}

